from itertools import combinations

def proizvod(o, a, b):
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])

def convex_hull(poeni):
    poeni = sorted(poeni)
    lower, upper = [], []
    
    for p in poeni:
        while len(lower) >= 2 and proizvod(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)
    
    for p in reversed(poeni):
        while len(upper) >= 2 and proizvod(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)
    
    return lower[:-1] + upper[:-1]

def poligon(polygon):
    n = len(polygon)
    area = 0
    for i in range(n):
        x1, y1 = polygon[i]
        x2, y2 = polygon[(i + 1) % n]
        area += x1 * y2 - y1 * x2
    return abs(area) // 2

def almost_convex_hull_area(poeni):
    n = len(poeni)
    min_area = float('inf')
    
    for i in range(n):
        oduzeto = poeni[:i] + poeni[i+1:]
        hull = convex_hull(oduzeto)
        area = poligon(hull)
        min_area = min(min_area, area)
    
    return min_area

n = int(input())
poeni = [tuple(map(int, input().split())) for _ in range(n)]
print(almost_convex_hull_area(poeni))